const express = require('express');
const bcrypt = require('bcrypt');
const router = express.Router();
const pool = require('../db');

router.post('/register', async (req, res) => {
    const { username, password } = req.body;
    if (!username || !password) {
        return res.status(400).send('Username and password cannot be empty');
    }

    const passwordHash = await bcrypt.hash(password, 10);
    try {
        await pool.query('INSERT INTO users (username, password_hash, coins) VALUES (?, ?,        0)', [username, passwordHash]);
        res.status(200).send('User  registered');
    } catch (error) {
        if (error.code === 'ER_DUP_ENTRY') {
            return res.status(400).send('Username already exists');
        }
        res.status(500).send('Database error');
    }
});

router.post('/login', async (req, res) => {
    const { username, password } = req.body;
    const [user] = await pool.query('SELECT id, password_hash FROM users WHERE username = ?', [username]);

    if (user.length === 0 || !(await bcrypt.compare(password, user[0].password_hash))) {
        return res.status(401).send('Invalid credentials');
    }

    res.status(200).json({ user_id: user[0].id, username });
});

module.exports = router;
