const express = require('express');
const router = express.Router();
const pool = require('../db');
const { DateTime } = require('luxon');

router.post('/send', async (req, res) => {
    const { room_id, user_id, user_name, gift_type, gift_name, gift_cost, gift_count } = req.body;

    if (gift_count <= 0 || gift_cost <= 0 || !gift_name.trim()) {
        return res.status(400).send('Invalid gift data');
    }

    const total_cost = gift_cost * gift_count;

    const connection = await pool.getConnection();
    try {
        await connection.beginTransaction();

        const [user] = await connection.query('SELECT coins FROM users WHERE id = ? FOR UPDATE', [user_id]);
        if (user.length === 0) {
            await connection.rollback();
            return res.status(404).send('User  not found');
        }

        let coins = user[0].coins;
        if (coins < total_cost) {
            await connection.rollback();
            return res.status(400).send('Insufficient coins');
        }

        coins -= total_cost;
        await connection.query('UPDATE users SET coins = ? WHERE id = ?', [coins, user_id]);

        const timestamp = DateTime.now().toMillis();
        await connection.query(`
            INSERT INTO gift_transactions 
            (sender_id, receiver_stream_id, gift_type, gift_name, coin_cost, amount, timestamp) 
            VALUES (?, ?, ?, ?, ?, ?, ?)`, 
            [user_id, room_id, gift_type, gift_name, gift_cost, gift_count, timestamp]
        );

        await connection.commit();
        res.status(200).json({
            user_id,
            user_name,
            gift_type,
            gift_count,
            timestamp
        });
    } catch (error) {
        await connection.rollback();
        res.status(500).send('Database error');
    } finally {
        connection.release();
    }
});

module.exports = router;
